/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPLayout;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.tools.FontSizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CartesianType1
extends AbstractAxes
implements CartesianAxes,
Dimensioned {
    double yMax;
    double yMin;
    double xMax;
    double xMin;
    boolean xlog = false;
    boolean ylog = false;
    static final double LOG10SCALE = 1.0 / Math.log(10.0);
    double ytickMax;
    double ytickMin;
    double xtickMax;
    double xtickMin;
    int yExponent;
    int xExponent;
    FontMetrics labelFontMetrics = null;
    FontMetrics superscriptFontMetrics = null;
    FontMetrics titleFontMetrics = null;
    int gridCurJuke = 0;
    double gridBase;
    protected DrawableTextLine xLine = new DrawableTextLine("x", 0.0, 0.0);
    protected DrawableTextLine yLine = new DrawableTextLine("y", 0.0, 0.0);
    ArrayList<Double> xticks = null;
    ArrayList<Double> yticks = null;
    ArrayList<String> xticklabels = null;
    ArrayList<String> yticklabels = null;
    NumberFormat numberFormat = NumberFormat.getInstance();
    NumberFormat scientificFormat = new DecimalFormat("0.0E0");
    boolean drawMajorXGrid = true;
    boolean drawMinorXGrid = false;
    boolean drawMajorYGrid = true;
    boolean drawMinorYGrid = false;
    private int topGutter = 25;
    private int bottomGutter = 45;
    private int leftGutter = 45;
    private int rightGutter = 25;
    private int tickLength = 5;
    private boolean adjustGutters = true;

    public CartesianType1(PlottingPanel plottingPanel) {
        super(plottingPanel);
        this.defaultTopGutter = this.topGutter;
        this.defaultBottomGutter = this.bottomGutter;
        this.defaultLeftGutter = this.leftGutter;
        this.defaultRightGutter = this.rightGutter;
        this.labelFont = new Font("Dialog", 0, 12);
        this.superscriptFont = new Font("Dialog", 0, 9);
        this.xLine.setJustification(0);
        this.xLine.setFont(this.labelFont);
        this.xLine.setPixelXY(true);
        this.yLine.setJustification(0);
        this.yLine.setFont(this.labelFont);
        this.yLine.setTheta(1.5707963267948966);
        this.yLine.setPixelXY(true);
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        this.titleLine.setPixelXY(true);
        if (plottingPanel == null) {
            return;
        }
        plottingPanel.setPreferredGutters(this.leftGutter, this.topGutter, this.rightGutter, this.bottomGutter);
        this.measureFonts(plottingPanel);
        plottingPanel.setAxes(this);
        plottingPanel.setCoordinateStringBuilder(CoordinateStringBuilder.createCartesian());
        this.resizeFonts(FontSizer.getFactor(FontSizer.getLevel()), plottingPanel);
    }

    private int xToPix(double d, DrawingPanel drawingPanel) {
        double[] dArray = drawingPanel.getPixelMatrix();
        double d2 = dArray[0] * d + dArray[4];
        if (d2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)d2);
    }

    private int yToPix(double d, DrawingPanel drawingPanel) {
        double[] dArray = drawingPanel.getPixelMatrix();
        double d2 = dArray[3] * d + dArray[5];
        if (d2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)d2);
    }

    private int getLeftGutter(DrawingPanel drawingPanel) {
        int n = 40;
        if (this.ylog) {
            return n + 10;
        }
        int n2 = drawingPanel.getHeight() - this.topGutter - this.bottomGutter;
        int n3 = 2 + n2 / (this.labelFontMetrics.getHeight() + 10);
        n3 = (int)((double)n3 / drawingPanel.getImageRatio());
        double d = this.roundUp((this.ytickMax - this.ytickMin) / (double)n3);
        double d2 = d * Math.ceil(this.ytickMin / d);
        int n4 = this.numFracDigits(d);
        double d3 = Math.abs(d / 100.0);
        if (d == 0.0 || Math.abs((this.ytickMax - d2) / d) > 50.0) {
            return n;
        }
        double d4 = d2;
        int n5 = this.labelFontMetrics.getHeight();
        int n6 = 0;
        while (n6 <= n3) {
            String string = this.formatNum(d4, n4, d3);
            int n7 = this.labelFontMetrics.stringWidth(string);
            n = Math.max(n7 + 2 * n5, n);
            d4 += d;
            ++n6;
        }
        return Math.min(n, drawingPanel.getWidth());
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        double d;
        if (!this.visible) {
            return;
        }
        this.topGutter = drawingPanel.getTopGutter();
        this.bottomGutter = drawingPanel.getBottomGutter();
        this.leftGutter = drawingPanel.getLeftGutter();
        this.rightGutter = drawingPanel.getRightGutter();
        this.yMax = drawingPanel.getYMax();
        this.yMin = drawingPanel.getYMin();
        this.xMax = drawingPanel.getXMax();
        this.xMin = drawingPanel.getXMin();
        if (this.xMax < this.xMin) {
            d = this.xMax;
            this.xMax = this.xMin;
            this.xMin = d;
        }
        if (this.yMax < this.yMin) {
            d = this.yMax;
            this.yMax = this.yMin;
            this.yMin = d;
        }
        this.setXRange(this.xMin, this.xMax);
        this.setYRange(this.yMin, this.yMax);
        if (this.adjustGutters) {
            this.leftGutter = Math.max(this.leftGutter, this.getLeftGutter(drawingPanel));
            if (this.leftGutter != drawingPanel.getLeftGutter()) {
                drawingPanel.setGutters(this.leftGutter, this.topGutter, this.rightGutter, this.bottomGutter);
                drawingPanel.recomputeTransform();
            }
        }
        this.drawPlot(drawingPanel, graphics);
    }

    public void addXTick(String string, double d) {
        if (this.xticks == null) {
            this.xticks = new ArrayList();
            this.xticklabels = new ArrayList();
        }
        this.xticks.add(new Double(d));
        this.xticklabels.add(string);
    }

    public void addYTick(String string, double d) {
        if (this.yticks == null) {
            this.yticks = new ArrayList();
            this.yticklabels = new ArrayList();
        }
        this.yticks.add(new Double(d));
        this.yticklabels.add(string);
    }

    public void setLabelFont(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.labelFont = Font.decode(string);
    }

    @Override
    public void setTitle(String string, String string2) {
        this.titleLine.setText(string);
        if (string2 == null || string2.equals("")) {
            return;
        }
        this.titleLine.setFont(Font.decode(string2));
        this.setTitleFont(string2);
    }

    public void setTitleFont(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.titleFont = Font.decode(string);
        this.titleLine.setFont(this.titleFont);
    }

    @Override
    public void setXLabel(String string, String string2) {
        this.xLine.setText(string);
        if (string2 == null || string2.equals("")) {
            return;
        }
        this.xLine.setFont(Font.decode(string2));
        this.setLabelFont(string2);
    }

    @Override
    public void setXLog(boolean bl) {
        this.xlog = bl;
    }

    @Override
    public void setYLabel(String string, String string2) {
        this.yLine.setText(string);
        if (string2 == null || string2.equals("")) {
            return;
        }
        this.yLine.setFont(Font.decode(string2));
        this.setLabelFont(string2);
    }

    @Override
    public void setYLog(boolean bl) {
        this.ylog = bl;
    }

    @Override
    public String getTitle() {
        return this.titleLine.getText();
    }

    @Override
    public String getXLabel() {
        return this.xLine.getText();
    }

    @Override
    public boolean isXLog() {
        return this.xlog;
    }

    @Override
    public String getYLabel() {
        return this.yLine.getText();
    }

    @Override
    public boolean isYLog() {
        return this.ylog;
    }

    @Override
    public void resizeFonts(double d, DrawingPanel drawingPanel) {
        super.resizeFonts(d, drawingPanel);
        if (this.xLine == null) {
            return;
        }
        this.xLine.setFont(this.labelFont);
        this.yLine.setFont(this.labelFont);
        int n = (int)((double)this.defaultLeftGutter * d);
        int n2 = (int)((double)this.defaultBottomGutter * d);
        int n3 = (int)((double)this.defaultTopGutter * (1.0 + d) / 2.0);
        int n4 = (int)((double)this.defaultRightGutter * (1.0 + d) / 2.0);
        drawingPanel.setPreferredGutters(n, n3, n4, n2);
        this.measureFonts(drawingPanel);
    }

    protected void drawPlot(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        double d;
        int n2;
        int n3;
        double d2;
        int n4;
        Object object;
        int n5;
        Color color = drawingPanel.getForeground();
        int n6 = drawingPanel.getHeight();
        int n7 = drawingPanel.getWidth();
        Shape shape = graphics.getClip();
        Font font = graphics.getFont();
        graphics.clipRect(0, 0, n7, n6);
        graphics.setFont(this.labelFont);
        graphics.setColor(color);
        int n8 = n7 - this.rightGutter;
        int n9 = n6 - this.bottomGutter;
        int n10 = n5 = this.titleFontMetrics.getHeight();
        int n11 = this.labelFontMetrics.getHeight();
        int n12 = n11 / 2;
        int n13 = n6 - 5;
        int n14 = n7 - 5 - OSPLayout.macOffset;
        if (this.xlog) {
            this.xExponent = (int)Math.floor(this.xtickMin);
        }
        if (this.xExponent != 0 && this.xticks == null) {
            String string = Integer.toString(this.xExponent);
            n14 -= this.superscriptFontMetrics.stringWidth(string);
            graphics.setFont(this.superscriptFont);
            if (!this.xlog) {
                graphics.drawString(string, n14, n13 - n12);
                graphics.setFont(this.labelFont);
                graphics.drawString("x 10", n14 -= this.labelFontMetrics.stringWidth("x 10"), n13);
            }
        }
        int n15 = n6 - this.topGutter - this.bottomGutter;
        int n16 = 2 + n15 / (n11 + 10);
        n16 = (int)((double)n16 / drawingPanel.getImageRatio());
        double d3 = this.roundUp((this.ytickMax - this.ytickMin) / (double)n16);
        double d4 = d3 * Math.ceil(this.ytickMin / d3);
        int n17 = n7 - this.rightGutter - this.leftGutter;
        if (this.interiorColor != null) {
            graphics.setColor(this.interiorColor);
            graphics.fillRect(this.leftGutter, this.topGutter, n17, n15);
        }
        int n18 = this.leftGutter + this.tickLength;
        int n19 = n8 - this.tickLength;
        int n20 = this.numFracDigits(d3);
        int n21 = 12;
        if (this.yticks == null) {
            int n22;
            object = null;
            double d5 = d4;
            if (this.ylog) {
                object = this.gridInit(d4, d3, true, null);
                d5 = this.gridStep((ArrayList<Double>)object, d4, d3, this.ylog);
            }
            n4 = this.ylog;
            boolean bl = true;
            graphics.setColor(color);
            d2 = Math.abs(d3 / 100.0);
            n3 = n16;
            double d6 = d5;
            while (d6 <= this.ytickMax) {
                if (--n3 < 0) break;
                String string = null;
                if (this.ylog) {
                    string = this.formatLogNum(d6, n20);
                    if (string.indexOf(101) != -1) {
                        n4 = 0;
                    }
                } else {
                    string = this.formatNum(d6, n20, d2);
                }
                int n23 = 0;
                n23 = this.ylog || this.yExponent == 0 ? this.yToPix(d6, drawingPanel) : this.yToPix(d6 * Math.pow(10.0, this.yExponent), drawingPanel);
                int n24 = n11 / 4;
                if (bl && !this.ylog) {
                    bl = false;
                    n24 = 0;
                }
                graphics.drawLine(this.leftGutter, n23, n18, n23);
                graphics.drawLine(n17 + this.leftGutter - 1, n23, n19, n23);
                if (this.drawMajorYGrid && n23 >= this.topGutter && n23 <= n9) {
                    graphics.setColor(this.gridcolor);
                    graphics.drawLine(n18, n23, n19, n23);
                    graphics.setColor(color);
                }
                n22 = this.labelFontMetrics.stringWidth(string);
                graphics.drawString(string, this.leftGutter - n22 - 4, n23 + n24);
                n2 = this.labelFontMetrics.stringWidth(string);
                n21 = Math.max(n21, n2);
                d6 = this.gridStep((ArrayList<Double>)object, d6, d3, this.ylog);
            }
            if (this.ylog || this.drawMinorYGrid) {
                ArrayList<Double> arrayList = this.gridInit(d4, d3, false, (ArrayList<Double>)object);
                if (arrayList.size() > 0) {
                    d = d3 > 1.0 ? 1.0 : d3;
                    double d7 = this.gridStep(arrayList, d4, d, this.ylog);
                    while (d7 <= this.ytickMax) {
                        n22 = this.yToPix(d7, drawingPanel);
                        if (n22 != this.topGutter && n22 != n9) {
                            graphics.setColor(this.gridcolor);
                            graphics.drawLine(this.leftGutter + 1, n22, n8 - 1, n22);
                            graphics.setColor(color);
                        }
                        d7 = this.gridStep(arrayList, d7, d, this.ylog);
                    }
                }
                this.yExponent = n4 != 0 ? (int)Math.floor(d5) : 0;
            }
            if (this.yExponent != 0) {
                graphics.drawString("x 10", 2, n10);
                graphics.setFont(this.superscriptFont);
                graphics.drawString(Integer.toString(this.yExponent), this.labelFontMetrics.stringWidth("x 10") + 2, n10 - n12);
                graphics.setFont(this.labelFont);
            }
        } else {
            object = this.yticks.iterator();
            for (String string : this.yticklabels) {
                n4 = this.labelFontMetrics.stringWidth(string);
                n21 = Math.max(n21, n4);
                double d8 = (Double)object.next();
                if (d8 > this.yMax || d8 < this.yMin) continue;
                n = this.yToPix(d8 * Math.pow(10.0, this.yExponent), drawingPanel);
                n3 = 0;
                if (d8 < (double)(n9 - n11)) {
                    n3 = n12;
                }
                graphics.drawLine(this.leftGutter, n, n18, n);
                graphics.drawLine(n17 + this.leftGutter - 1, n, n19, n);
                if (this.drawMajorYGrid && n >= this.topGutter && n <= n9) {
                    graphics.setColor(this.gridcolor);
                    graphics.drawLine(n18, n, n19, n);
                    graphics.setColor(color);
                }
                graphics.drawString(string, this.leftGutter - this.labelFontMetrics.stringWidth(string) - 3, n + n3);
            }
        }
        int n25 = this.topGutter + this.tickLength;
        int n26 = n9 - this.tickLength;
        int n27 = this.labelFontMetrics.stringWidth("8");
        if (this.xticks == null) {
            ArrayList<Double> arrayList;
            n4 = 10;
            n4 = (int)((double)n4 / drawingPanel.getImageRatio());
            double d9 = 0.0;
            n20 = 0;
            if (this.xlog) {
                n4 = 4 + n17 / (n27 * 6 + 10);
                n4 = (int)((double)n4 / drawingPanel.getImageRatio());
            } else {
                n = 0;
                while (n++ <= 10) {
                    int n28;
                    d9 = this.roundUp((this.xtickMax - this.xtickMin) / (double)n4);
                    n20 = this.numFracDigits(d9);
                    n3 = this.numIntDigits(this.xtickMax);
                    if (n3 < (n28 = this.numIntDigits(this.xtickMin))) {
                        n3 = n28;
                    }
                    int n29 = n27 * (n20 + 2 + n3);
                    int n30 = n4;
                    n4 = 2 + n17 / (n29 + 10);
                    if ((n4 = (int)((double)n4 / drawingPanel.getImageRatio())) - n30 <= 1 || n30 - n4 <= 1) break;
                }
            }
            d9 = this.xlog ? this.roundUp(0.8 * (this.xtickMax - this.xtickMin) / (double)n4) : this.roundUp((this.xtickMax - this.xtickMin) / (double)n4);
            n20 = this.numFracDigits(d9);
            double d10 = d9 * Math.ceil(this.xtickMin / d9);
            ArrayList<Double> arrayList2 = null;
            d = d10;
            if (this.xlog) {
                d10 = d9 * Math.floor(this.xtickMin / d9);
                arrayList2 = this.gridInit(d10, d9, true, null);
                d = this.gridRoundUp(arrayList2, d10);
            }
            boolean bl = this.xlog;
            graphics.setColor(color);
            double d11 = Math.abs(d3 / 100.0);
            n2 = n4;
            double d12 = d;
            while (d12 <= this.xtickMax) {
                if (--n2 < 0) break;
                arrayList = null;
                boolean bl2 = false;
                if (this.xlog) {
                    arrayList = this.formatLogNum(d12, n20);
                    if (((String)((Object)arrayList)).indexOf(101) != -1) {
                        bl = false;
                        bl2 = true;
                    }
                } else {
                    arrayList = this.formatNum(d12, n20, d11);
                }
                n18 = this.xlog || this.xExponent == 0 ? this.xToPix(d12, drawingPanel) : this.xToPix(d12 * Math.pow(10.0, this.xExponent), drawingPanel);
                graphics.drawLine(n18, this.topGutter, n18, n25);
                graphics.drawLine(n18, n15 + this.topGutter - 1, n18, n26);
                if (this.drawMajorXGrid && n18 >= this.leftGutter && n18 <= n8) {
                    graphics.setColor(this.gridcolor);
                    graphics.drawLine(n18, n25, n18, n26);
                    graphics.setColor(color);
                }
                int n31 = n18 - this.labelFontMetrics.stringWidth((String)((Object)arrayList)) / 2;
                if (bl2) {
                    graphics.drawString((String)((Object)arrayList), n31 + 7, n9 + 3 + n11);
                } else {
                    graphics.drawString((String)((Object)arrayList), n31, n9 + 3 + n11);
                }
                d12 = this.gridStep(arrayList2, d12, d9, this.xlog);
            }
            if (this.xlog || this.drawMinorXGrid) {
                d12 = d9 > 1.0 ? 1.0 : d9;
                d = d12 * Math.ceil(this.xtickMin / d12);
                arrayList = this.gridInit(d, d12, false, arrayList2);
                if (arrayList.size() > 0) {
                    double d13 = this.gridStep(arrayList, d, d12, this.xlog);
                    while (d13 <= this.xtickMax) {
                        n18 = this.xToPix(d13, drawingPanel);
                        if (n18 != this.leftGutter && n18 != n8) {
                            graphics.setColor(this.gridcolor);
                            graphics.drawLine(n18, this.topGutter + 1, n18, n9 - 1);
                            graphics.setColor(color);
                        }
                        d13 = this.gridStep(arrayList, d13, d12, this.xlog);
                    }
                }
                if (bl) {
                    this.xExponent = (int)Math.floor(d);
                    graphics.setFont(this.superscriptFont);
                    graphics.drawString(Integer.toString(this.xExponent), n14, n13 - n12);
                    graphics.setFont(this.labelFont);
                    graphics.drawString("x 10", n14 -= this.labelFontMetrics.stringWidth("x 10"), n13);
                } else {
                    this.xExponent = 0;
                }
            }
        } else {
            Iterator<Double> iterator = this.xticks.iterator();
            Iterator<String> iterator2 = this.xticklabels.iterator();
            d2 = 0.0;
            while (iterator2.hasNext()) {
                int n32;
                String string = iterator2.next();
                double d14 = iterator.next();
                if (d14 > this.xMax || d14 < this.xMin || !((double)(n32 = (n18 = this.xToPix(d14 * Math.pow(10.0, this.xExponent), drawingPanel)) - this.labelFontMetrics.stringWidth(string) / 2) > d2)) continue;
                d2 = n18 + this.labelFontMetrics.stringWidth(string) / 2 + 10;
                graphics.drawString(string, n32, n9 + 3 + n11);
                graphics.drawLine(n18, this.topGutter, n18, n25);
                graphics.drawLine(n18, n15 + this.topGutter - 1, n18, n26);
                if (!this.drawMajorXGrid || n18 < this.leftGutter || n18 > n8) continue;
                graphics.setColor(this.gridcolor);
                graphics.drawLine(n18, n25, n18, n26);
                graphics.setColor(color);
            }
        }
        graphics.setColor(color);
        if (this.titleLine != null) {
            this.titleLine.setX(drawingPanel.getLeftGutter() / 2 + (drawingPanel.getWidth() - drawingPanel.getRightGutter()) / 2);
            if ((double)drawingPanel.getTopGutter() > 1.2 * (double)this.labelFontMetrics.getHeight()) {
                this.titleLine.setY((double)drawingPanel.getTopGutter() - 0.6 * (double)this.labelFontMetrics.getHeight());
            } else {
                this.titleLine.setY((double)drawingPanel.getTopGutter() + 1.5 * (double)this.labelFontMetrics.getHeight());
            }
            this.titleLine.draw(drawingPanel, graphics);
        }
        if (this.xLine != null) {
            double d15 = (double)this.leftGutter / 2.0 + (double)(drawingPanel.getWidth() - this.rightGutter) / 2.0;
            this.xLine.setX(d15);
            int n33 = drawingPanel.getBottomGutter() - 2 * this.labelFontMetrics.getHeight();
            this.xLine.setY(drawingPanel.getHeight() - Math.max(0, n33));
            this.xLine.draw(drawingPanel, graphics);
        }
        if (this.yLine != null) {
            double d16 = (double)this.topGutter / 2.0 + (double)((drawingPanel.getHeight() - this.bottomGutter) / 2);
            this.yLine.setY(d16);
            double d17 = (double)(drawingPanel.getLeftGutter() - n21) - 0.7 * (double)this.labelFontMetrics.getHeight();
            this.yLine.setX(Math.max(12.0, d17));
            this.yLine.draw(drawingPanel, graphics);
        }
        graphics.setColor(color);
        graphics.drawRect(this.leftGutter, this.topGutter, n17 - 1, n15 - 1);
        graphics.setFont(font);
        graphics.setClip(shape);
    }

    private String formatLogNum(double d, int n) {
        int n2 = (int)d;
        String string = n2 >= 0 && n2 < 10 ? "0" + n2 : (n2 < 0 && n2 > -10 ? "-0" + -n2 : Integer.toString(n2));
        string = d >= 0.0 ? (d - (double)((int)d) < 0.001 ? "1e" + string : this.formatNum(Math.pow(10.0, d - (double)((int)d)), n, 1.4E-45f)) : (-d - (double)((int)(-d)) < 0.001 ? "1e" + string : this.formatNum(Math.pow(10.0, d - (double)((int)d)) * 10.0, n, 1.4E-45f));
        return string;
    }

    private String formatNum(double d, int n, double d2) {
        NumberFormat numberFormat;
        if (d == 0.0) {
            return "0";
        }
        if (Math.abs(d) < 0.01 && Math.abs(d) > d2) {
            numberFormat = this.scientificFormat;
        } else {
            numberFormat = this.numberFormat;
            numberFormat.setMinimumFractionDigits(n);
            numberFormat.setMaximumFractionDigits(n);
        }
        return numberFormat.format(d);
    }

    private ArrayList<Double> gridInit(double d, double d2, boolean bl, ArrayList<Double> arrayList) {
        ArrayList<Double> arrayList2 = new ArrayList<Double>(10);
        double d3 = Math.pow(10.0, d2);
        int n = 1;
        if (bl) {
            if (d3 <= 3.5) {
                if (d3 > 2.0) {
                    n = 2;
                } else if (d3 > 1.26) {
                    n = 5;
                } else if (d3 > 1.125) {
                    n = 10;
                } else {
                    n = (int)Math.rint(1.0 / d2);
                    n = 10;
                }
            }
        } else {
            n = d3 > 10.0 ? 1 : (d3 > 3.0 ? 2 : (d3 > 2.0 ? 5 : (d3 > 1.125 ? 10 : 100)));
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            double d4 = (double)n3 * 1.0 / (double)n * 10.0;
            double d5 = LOG10SCALE * Math.log(d4);
            if (d5 == Double.NEGATIVE_INFINITY) {
                d5 = 0.0;
            }
            if (arrayList != null && n2 < arrayList.size()) {
                while (n2 < arrayList.size() && arrayList.get(n2) < d5) {
                    ++n2;
                }
                if (n2 < arrayList.size()) {
                    if (Math.abs(arrayList.get(n2) - d5) > 1.0E-5) {
                        arrayList2.add(new Double(d5));
                    }
                } else {
                    arrayList2.add(new Double(d5));
                }
            } else {
                arrayList2.add(new Double(d5));
            }
            ++n3;
        }
        this.gridCurJuke = 0;
        if (d == -0.0) {
            d = 0.0;
        }
        this.gridBase = Math.floor(d);
        double d6 = d - this.gridBase;
        this.gridCurJuke = -1;
        while (this.gridCurJuke + 1 < arrayList2.size() && d6 >= arrayList2.get(this.gridCurJuke + 1)) {
            ++this.gridCurJuke;
        }
        return arrayList2;
    }

    private double gridRoundUp(ArrayList<Double> arrayList, double d) {
        double d2 = d - Math.floor(d);
        int n = 0;
        while (n < arrayList.size() && d2 >= arrayList.get(n)) {
            ++n;
        }
        if (n >= arrayList.size()) {
            return d;
        }
        return Math.floor(d) + arrayList.get(n);
    }

    private double gridStep(ArrayList<Double> arrayList, double d, double d2, boolean bl) {
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        if (bl) {
            if (++this.gridCurJuke >= arrayList.size()) {
                this.gridCurJuke = 0;
                this.gridBase += Math.ceil(d2);
            }
            if (this.gridCurJuke >= arrayList.size()) {
                return d + d2;
            }
            return this.gridBase + arrayList.get(this.gridCurJuke);
        }
        if (d + d2 == d) {
            while (d + d2 == d) {
                d2 *= 2.0;
            }
            return d + d2;
        }
        return d + d2;
    }

    private void measureFonts(JPanel jPanel) {
        this.labelFontMetrics = jPanel.getFontMetrics(this.labelFont);
        this.superscriptFontMetrics = jPanel.getFontMetrics(this.superscriptFont);
        this.titleFontMetrics = jPanel.getFontMetrics(this.titleFont);
    }

    private int numFracDigits(double d) {
        int n = 0;
        while (n <= 15 && d != Math.floor(d)) {
            d *= 10.0;
            ++n;
        }
        return n;
    }

    private int numIntDigits(double d) {
        int n = 0;
        while (n <= 15 && (double)((int)d) != 0.0) {
            d /= 10.0;
            ++n;
        }
        return n;
    }

    private double roundUp(double d) {
        int n;
        d = (d *= Math.pow(10.0, -(n = (int)Math.floor(Math.log(d) * LOG10SCALE)))) > 5.0 ? 10.0 : (d > 2.0 ? 5.0 : (d > 1.0 ? 2.0 : 1.0));
        return d *= Math.pow(10.0, n);
    }

    private void setXRange(double d, double d2) {
        double d3 = Math.max(Math.abs(this.xMin), Math.abs(this.xMax));
        double d4 = Math.abs(this.xMax - this.xMin);
        this.xExponent = this.xMin >= 0.0 && this.xMax <= 1000.0 && d4 > 0.1 && !this.xlog ? 0 : (int)Math.floor(Math.log(d3) * LOG10SCALE);
        if (this.xExponent > 1 || this.xExponent < -1) {
            double d5 = 1.0 / Math.pow(10.0, this.xExponent);
            this.xtickMin = this.xMin * d5;
            this.xtickMax = this.xMax * d5;
        } else {
            this.xtickMin = this.xMin;
            this.xtickMax = this.xMax;
            this.xExponent = 0;
        }
    }

    private void setYRange(double d, double d2) {
        double d3 = Math.max(Math.abs(this.yMin), Math.abs(this.yMax));
        this.yExponent = this.yMin >= 0.0 && this.yMax <= 1000.0 && !this.ylog ? 0 : (int)Math.floor(Math.log(d3) * LOG10SCALE);
        if (this.yExponent > 1 || this.yExponent < -1) {
            double d4 = 1.0 / Math.pow(10.0, this.yExponent);
            this.ytickMin = this.yMin * d4;
            this.ytickMax = this.yMax * d4;
        } else {
            this.ytickMin = this.yMin;
            this.ytickMax = this.yMax;
            this.yExponent = 0;
        }
    }

    @Override
    public void setShowMajorXGrid(boolean bl) {
        this.drawMajorXGrid = bl;
        if (!bl) {
            this.drawMinorXGrid = bl;
        }
    }

    @Override
    public void setShowMinorXGrid(boolean bl) {
        this.drawMinorXGrid = bl;
    }

    @Override
    public void setShowMajorYGrid(boolean bl) {
        this.drawMajorYGrid = bl;
        if (!bl) {
            this.drawMinorYGrid = bl;
        }
    }

    @Override
    public void setShowMinorYGrid(boolean bl) {
        this.drawMinorYGrid = bl;
    }

    @Override
    public void setX(double d) {
    }

    @Override
    public void setY(double d) {
    }

    @Override
    public double getX() {
        return 0.0;
    }

    @Override
    public double getY() {
        return 0.0;
    }

    @Override
    public Dimension getInterior(DrawingPanel drawingPanel) {
        this.adjustGutters = drawingPanel.getDimensionSetter() == null;
        return null;
    }
}

