/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class NumberField
extends JTextField {
    protected DecimalFormat format = (DecimalFormat)NumberFormat.getInstance();
    protected double prevValue;
    protected Double maxValue;
    protected Double minValue;
    protected int sigfigs;
    protected boolean fixedPattern = false;
    protected String[] patterns = new String[5];
    protected double[] ranges = new double[]{1.0, 10.0, 100.0, 1000.0};
    protected String units;

    public NumberField(int n) {
        this(n, 4);
    }

    public NumberField(int n, int n2) {
        super(n);
        this.setText("0");
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    Runnable runnable = new Runnable(){

                        public synchronized void run() {
                            NumberField.this.setBackground(Color.white);
                            NumberField.this.setValue(NumberField.this.getValue());
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                } else {
                    NumberField.this.setBackground(Color.yellow);
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                Runnable runnable = new Runnable(){

                    public synchronized void run() {
                        NumberField.this.setBackground(Color.white);
                        NumberField.this.setValue(NumberField.this.getValue());
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    NumberField.this.selectAll();
                }
            }
        });
        this.setSigFigs(n2);
    }

    public double getValue() {
        double d;
        String string = this.getText().trim();
        if (this.units != null && !this.units.equals("")) {
            int n = string.indexOf(this.units);
            while (n > -1) {
                string = string.substring(0, n);
                n = string.indexOf(this.units);
            }
        }
        if (string.equals(this.format.format(this.prevValue))) {
            return this.prevValue;
        }
        try {
            d = this.format.parse(string).doubleValue();
            if (this.minValue != null && d < this.minValue) {
                this.setValue(this.minValue);
                return this.minValue;
            }
            if (this.maxValue != null && d > this.maxValue) {
                this.setValue(this.maxValue);
                return this.maxValue;
            }
        }
        catch (ParseException parseException) {
            Toolkit.getDefaultToolkit().beep();
            this.setValue(this.prevValue);
            return this.prevValue;
        }
        return d;
    }

    public void setValue(double d) {
        if (!this.isVisible()) {
            return;
        }
        if (this.minValue != null) {
            d = Math.max(d, this.minValue);
        }
        if (this.maxValue != null) {
            d = Math.min(d, this.maxValue);
        }
        this.setFormatFor(d);
        String string = this.format.format(d);
        if (this.units != null) {
            string = String.valueOf(string) + this.units;
        }
        if (!string.equals(this.getText())) {
            this.setText(string);
        }
        this.prevValue = d;
    }

    public void setExpectedRange(double d, double d2) {
        this.fixedPattern = true;
        double d3 = Math.max(Math.abs(d), Math.abs(d2));
        char c = '.';
        if (d3 < 0.1 || d3 >= 1000.0) {
            String string = "";
            int n = 0;
            while (n < this.sigfigs - 1) {
                string = String.valueOf(string) + "0";
                ++n;
            }
            this.format.applyPattern("0" + c + string + "E0");
        } else {
            int n = d3 < 1.0 ? this.sigfigs : (d3 < 10.0 ? this.sigfigs - 1 : (d3 < 100.0 ? this.sigfigs - 2 : this.sigfigs - 3));
            String string = "";
            int n2 = 0;
            while (n2 < n) {
                string = String.valueOf(string) + "0";
                ++n2;
            }
            if (string.equals("")) {
                this.format.applyPattern("0");
            } else {
                this.format.applyPattern("0" + c + string);
            }
        }
    }

    public void setSigFigs(int n) {
        if (this.sigfigs == n) {
            return;
        }
        this.ranges = new double[]{1.0, 10.0, 100.0, 1000.0};
        n = Math.max(n, 2);
        this.sigfigs = Math.min(n, 6);
        char c = '.';
        if (n == 2) {
            this.patterns[0] = "0" + c + "0E0";
            this.patterns[1] = "0" + c + "0";
            this.patterns[2] = "0";
            this.patterns[3] = "0" + c + "0E0";
            this.patterns[4] = "0" + c + "0E0";
        } else if (n == 3) {
            this.patterns[0] = "0" + c + "00E0";
            this.patterns[1] = "0" + c + "00";
            this.patterns[2] = "0" + c + "0";
            this.patterns[3] = "0";
            this.patterns[4] = "0" + c + "00E0";
        } else if (n >= 4) {
            this.patterns[0] = "0" + c + "000E0";
            this.patterns[1] = "0" + c + "000";
            this.patterns[2] = "0" + c + "00";
            this.patterns[3] = "0" + c + "0";
            this.patterns[4] = "0" + c + "000E0";
            int n2 = n - 4;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < this.patterns.length) {
                    this.patterns[n4] = "0" + c + "0" + this.patterns[n4].substring(2);
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public void setMinValue(double d) {
        this.minValue = Double.isNaN(d) ? null : new Double(d);
    }

    public void setMaxValue(double d) {
        this.maxValue = Double.isNaN(d) ? null : new Double(d);
    }

    public void setUnits(String string) {
        double d = this.getValue();
        this.units = string;
        this.setValue(d);
    }

    public String getUnits() {
        return this.units;
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public void setFormatFor(double d) {
        if (this.fixedPattern) {
            return;
        }
        if ((d = Math.abs(d)) < this.ranges[0]) {
            this.format.applyPattern(this.patterns[0]);
        } else if (d < this.ranges[1]) {
            this.format.applyPattern(this.patterns[1]);
        } else if (d < this.ranges[2]) {
            this.format.applyPattern(this.patterns[2]);
        } else if (d < this.ranges[3]) {
            this.format.applyPattern(this.patterns[3]);
        } else {
            this.format.applyPattern(this.patterns[4]);
        }
    }

    public void setPatterns(String[] stringArray) {
        this.setPatterns(stringArray, new double[]{1.0, 10.0, 100.0, 1000.0});
    }

    public void setPatterns(String[] stringArray, double[] dArray) {
        if (stringArray.length > 4 && dArray.length > 3) {
            this.patterns = stringArray;
            this.ranges = dArray;
        }
    }
}

