/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.desktop;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import org.opensourcephysics.desktop.ostermiller.Browser;

public class OSPDesktop {
    static final String desktopClassName = "java.awt.Desktop";
    static boolean desktopSupported;

    static {
        try {
            Method method = Class.forName(desktopClassName).getMethod("isDesktopSupported", null);
            desktopSupported = (Boolean)method.invoke(null, null);
        }
        catch (Exception exception) {
            desktopSupported = false;
        }
    }

    public static boolean displayURL(String string) {
        try {
            if (!OSPDesktop.browse(string)) {
                Browser.init();
                Browser.displayURL(string);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDesktopSupported() {
        return desktopSupported;
    }

    public static boolean browse(String string) {
        if (!desktopSupported) {
            return false;
        }
        try {
            return OSPDesktop.browse(new URI(string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean browse(URI uRI) {
        if (!desktopSupported || uRI == null) {
            return false;
        }
        Class[] classArray = new Class[]{URI.class};
        try {
            Method method = Class.forName(desktopClassName).getMethod("getDesktop", null);
            Object object = method.invoke(null, null);
            method = Class.forName(desktopClassName).getMethod("browse", classArray);
            Object[] objectArray = new Object[]{uRI};
            method.invoke(object, objectArray);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean mail(String string) {
        if (!desktopSupported || string == null) {
            return false;
        }
        Class[] classArray = new Class[]{URI.class};
        try {
            URI uRI = new URI("mailto:" + string.trim());
            Method method = Class.forName(desktopClassName).getMethod("getDesktop", null);
            Object object = method.invoke(null, null);
            method = Class.forName(desktopClassName).getMethod("mail", classArray);
            Object[] objectArray = new Object[]{uRI};
            method.invoke(object, objectArray);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean mail() {
        if (!desktopSupported) {
            return false;
        }
        try {
            Method method = Class.forName(desktopClassName).getMethod("getDesktop", null);
            Object object = method.invoke(null, null);
            method = Class.forName(desktopClassName).getMethod("mail", null);
            method.invoke(object, null);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean edit(File file) {
        if (!desktopSupported) {
            return false;
        }
        Class[] classArray = new Class[]{File.class};
        try {
            Method method = Class.forName(desktopClassName).getMethod("getDesktop", null);
            Object object = method.invoke(null, null);
            method = Class.forName(desktopClassName).getMethod("edit", classArray);
            Object[] objectArray = new Object[]{file};
            method.invoke(object, objectArray);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean open(File file) {
        if (!desktopSupported) {
            return false;
        }
        Class[] classArray = new Class[]{File.class};
        try {
            Method method = Class.forName(desktopClassName).getMethod("getDesktop", null);
            Object object = method.invoke(null, null);
            method = Class.forName(desktopClassName).getMethod("open", classArray);
            Object[] objectArray = new Object[]{file};
            method.invoke(object, objectArray);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

