/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.value;

import org.colos.ejs.library.control.PropertyEditor;
import org.colos.ejs.library.control.value.Value;

public class InterpretedValue
extends Value {
    private String expression;
    private PropertyEditor myEjsPropertyEditor;

    public InterpretedValue(String string, PropertyEditor propertyEditor) {
        this.myEjsPropertyEditor = propertyEditor;
        this.expression = new String(string.trim());
    }

    public boolean getBoolean() {
        try {
            return (Boolean)this.getObject();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getInteger() {
        try {
            return (Integer)this.getObject();
        }
        catch (Exception exception) {
            try {
                return (int)Math.round((Double)this.getObject());
            }
            catch (Exception exception2) {
                return 0;
            }
        }
    }

    public double getDouble() {
        try {
            return (Double)this.getObject();
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public String getString() {
        return this.getObject().toString();
    }

    public Object getObject() {
        return this.myEjsPropertyEditor.evaluateExpression(this.expression);
    }

    public void copyValue(Value value) {
        this.expression = value instanceof InterpretedValue ? new String(((InterpretedValue)value).expression) : new String(value.getString());
    }

    public Value cloneValue() {
        return new InterpretedValue(this.expression, this.myEjsPropertyEditor);
    }
}

